/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.session.handler;

import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.commands.CommandUtils;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.Handler;
import java.util.Set;

public class EntryFlag
extends Handler {
    public static final Factory FACTORY = new Factory();
    private static final long MESSAGE_THRESHOLD = 2000L;
    private long lastMessage;

    public EntryFlag(Session session) {
        super(session);
    }

    @Override
    public boolean onCrossBoundary(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Set<ProtectedRegion> entered, Set<ProtectedRegion> exited, MoveType moveType) {
        boolean allowed = toSet.testState(player, Flags.ENTRY);
        if (!this.getSession().getManager().hasBypass(player, (World)to.getExtent()) && !allowed && moveType.isCancellable()) {
            String message = toSet.queryValue(player, Flags.ENTRY_DENY_MESSAGE);
            long now = System.currentTimeMillis();
            if (now - this.lastMessage > 2000L && message != null && !message.isEmpty()) {
                player.printRaw(CommandUtils.replaceColorMacros(message));
                this.lastMessage = now;
            }
            return false;
        }
        return true;
    }

    public static class Factory
    extends Handler.Factory<EntryFlag> {
        @Override
        public EntryFlag create(Session session) {
            return new EntryFlag(session);
        }
    }
}

