/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.protection.regions;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.config.ConfigurationManager;
import com.sk89q.worldguard.config.WorldConfiguration;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.FailedLoadRegionSet;
import com.sk89q.worldguard.protection.PermissiveRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.MapFlag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.QueryCache;
import java.util.Collection;
import javax.annotation.Nullable;

public class RegionQuery {
    private final ConfigurationManager config;
    private final QueryCache cache;

    public RegionQuery(QueryCache cache) {
        Preconditions.checkNotNull((Object)cache);
        this.config = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        this.cache = cache;
    }

    public ApplicableRegionSet getApplicableRegions(Location location) {
        Preconditions.checkNotNull((Object)location);
        World world = (World)location.getExtent();
        WorldConfiguration worldConfig = this.config.get(world);
        if (!worldConfig.useRegions) {
            return PermissiveRegionSet.getInstance();
        }
        RegionManager manager = WorldGuard.getInstance().getPlatform().getRegionContainer().get((World)location.getExtent());
        if (manager != null) {
            return this.cache.queryContains(manager, location);
        }
        return FailedLoadRegionSet.getInstance();
    }

    public boolean testBuild(Location location, LocalPlayer player, StateFlag ... flag) {
        if (flag.length == 0) {
            return this.testState(location, player, Flags.BUILD);
        }
        return StateFlag.test(StateFlag.combine(StateFlag.denyToNone(this.queryState(location, player, Flags.BUILD)), this.queryState(location, player, flag)));
    }

    public boolean testBuild(Location location, RegionAssociable associable, StateFlag ... flag) {
        if (flag.length == 0) {
            return this.testState(location, associable, Flags.BUILD);
        }
        return StateFlag.test(StateFlag.combine(StateFlag.denyToNone(this.queryState(location, associable, Flags.BUILD)), this.queryState(location, associable, flag)));
    }

    public <K> boolean testBuild(Location location, RegionAssociable associable, MapFlag<K, StateFlag.State> mapFlag, K key, @Nullable StateFlag fallback, StateFlag ... flag) {
        if (mapFlag == null) {
            return this.testBuild(location, associable, flag);
        }
        if (flag.length == 0) {
            return StateFlag.test(StateFlag.combine(StateFlag.denyToNone(this.queryState(location, associable, Flags.BUILD)), this.queryMapValue(location, associable, mapFlag, key, fallback)));
        }
        return StateFlag.test(StateFlag.combine(StateFlag.denyToNone(this.queryState(location, associable, Flags.BUILD)), this.queryMapValue(location, associable, mapFlag, key, fallback), this.queryState(location, associable, flag)));
    }

    public boolean testState(Location location, @Nullable LocalPlayer player, StateFlag ... flag) {
        return StateFlag.test(this.queryState(location, player, flag));
    }

    public boolean testState(Location location, @Nullable RegionAssociable associable, StateFlag ... flag) {
        return StateFlag.test(this.queryState(location, associable, flag));
    }

    @Nullable
    public StateFlag.State queryState(Location location, @Nullable LocalPlayer player, StateFlag ... flags) {
        return this.getApplicableRegions(location).queryState(player, flags);
    }

    @Nullable
    public StateFlag.State queryState(Location location, @Nullable RegionAssociable associable, StateFlag ... flags) {
        return this.getApplicableRegions(location).queryState(associable, flags);
    }

    @Nullable
    public <V> V queryValue(Location location, @Nullable LocalPlayer player, Flag<V> flag) {
        return this.getApplicableRegions(location).queryValue(player, flag);
    }

    @Nullable
    public <V> V queryValue(Location location, @Nullable RegionAssociable associable, Flag<V> flag) {
        return this.getApplicableRegions(location).queryValue(associable, flag);
    }

    @Nullable
    public <V, K> V queryMapValue(Location location, @Nullable RegionAssociable subject, MapFlag<K, V> flag, K key) {
        return this.getApplicableRegions(location).queryMapValue(subject, flag, key);
    }

    @Nullable
    public <V, K> V queryMapValue(Location location, @Nullable RegionAssociable subject, MapFlag<K, V> flag, K key, Flag<V> fallback) {
        return this.getApplicableRegions(location).queryMapValue(subject, flag, key, fallback);
    }

    public <V> Collection<V> queryAllValues(Location location, @Nullable LocalPlayer player, Flag<V> flag) {
        return this.getApplicableRegions(location).queryAllValues(player, flag);
    }

    public <V> Collection<V> queryAllValues(Location location, @Nullable RegionAssociable associable, Flag<V> flag) {
        return this.getApplicableRegions(location).queryAllValues(associable, flag);
    }
}

