/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.protection.association;

import com.google.common.base.Preconditions;
import com.sk89q.worldguard.domains.Association;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class AbstractRegionOverlapAssociation
implements RegionAssociable {
    @Nullable
    protected Set<ProtectedRegion> source;
    private boolean useMaxPriorityAssociation;
    private int maxPriority;

    protected AbstractRegionOverlapAssociation(@Nullable Set<ProtectedRegion> source, boolean useMaxPriorityAssociation) {
        this.source = source;
        this.useMaxPriorityAssociation = useMaxPriorityAssociation;
    }

    protected void calcMaxPriority() {
        Preconditions.checkNotNull(this.source);
        int best = 0;
        for (ProtectedRegion region : this.source) {
            int priority = region.getPriority();
            if (priority <= best) continue;
            best = priority;
        }
        this.maxPriority = best;
    }

    @Override
    public Association getAssociation(List<ProtectedRegion> regions) {
        Preconditions.checkNotNull(this.source);
        for (ProtectedRegion region : regions) {
            if (region.getId().equals("__global__") && this.source.isEmpty()) {
                return Association.OWNER;
            }
            if (!this.source.contains(region)) continue;
            if (this.useMaxPriorityAssociation) {
                int priority = region.getPriority();
                if (priority != this.maxPriority) continue;
                return Association.OWNER;
            }
            return Association.OWNER;
        }
        return Association.NON_MEMBER;
    }
}

